<h3 class="mb-3 fw-bold">Data Siswa</h3>
<div class="card border-0 shadow-sm">
    <div class="card-body">
        <div class="mb-3">
            <button class="btn btn-primary fw-bold" data-bs-toggle="modal" data-bs-target="#mSiswa">Tambah Siswa</button>
        </div>
        
        <table id="tabelSiswa" class="table table-bordered table-hover w-100 table-data">
            <thead class="table-light">
                <tr>
                    <th>NIS</th>
                    <th>Nama</th>
                    <th>Kelas</th>
                    <th>Status</th> <!-- Kolom Baru -->
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                $q = mysqli_query($koneksi, "SELECT * FROM siswa ORDER BY kelas ASC"); 
                while($d = mysqli_fetch_array($q)){ 
                    // Logic Warna Badge Status
                    // Kalau Aktif warnanya Hijau, selain itu (Alumni/Pindah) warnanya Abu-abu
                    $bg_status = ($d['status'] == 'Aktif') ? 'bg-success' : 'bg-secondary';
                ?>
                <tr>
                    <td><?php echo $d['nis']; ?></td>
                    <td><?php echo $d['nama']; ?></td>
                    <td><?php echo $d['kelas']; ?></td>
                    <td>
                        <span class="badge <?php echo $bg_status; ?>">
                            <?php echo $d['status']; ?>
                        </span>
                    </td>
                    <td class="text-center">
                        <!-- Tombol Edit -->
                        <a href="?page=edit_siswa&id=<?php echo $d['id']; ?>" class="btn btn-sm btn-warning py-0">Edit</a>
                        <!-- Tombol Hapus -->
                        <a href="proses/act_siswa.php?aksi=hapus&id=<?php echo $d['id']; ?>" class="btn btn-sm btn-danger py-0" onclick="return confirm('Hapus?')">X</a>
                    </td>
                </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Modal Tambah Siswa -->
<div class="modal fade" id="mSiswa">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST" action="proses/act_siswa.php">
                <div class="modal-header"><h5>Tambah Siswa</h5></div>
                <div class="modal-body">
                    <div class="mb-2">
                        <label>NIS</label>
                        <input name="nis" class="form-control" placeholder="Nomor Induk" required>
                    </div>
                    <div class="mb-2">
                        <label>Nama Lengkap</label>
                        <input name="nama" class="form-control" placeholder="Nama Siswa" required>
                    </div>
                    <div class="mb-2">
                        <label>Kelas</label>
                        <select name="kelas" class="form-select">
                            <option>X-A</option>
                            <option>X-B</option>
                            <option>XI-IPA</option>
                            <option>XI-IPS</option>
                            <option>XII-IPA</option>
                            <option>XII-IPS</option>
                        </select>
                    </div>
                    <div class="mb-2">
                        <label>Status</label>
                        <select name="status" class="form-select">
                            <option value="Aktif">Aktif</option>
                            <option value="Alumni">Alumni</option>
                            <option value="Pindah">Pindah</option>
                            <option value="DO">Drop Out</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" name="simpan_siswa" class="btn btn-primary">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>